import React from 'react';

interface FiresideCabinThemeProps {
  mode: 'light' | 'dusky';
}

const FiresideCabinTheme: React.FC<FiresideCabinThemeProps> = ({ mode }) => {
  const styles = {
    light: {
      backgroundColor: '#f5f5dc',
      color: '#333333',
      accentColor: '#8b4513',
      secondaryColor: '#fff8dc',
      borderColor: '#deb887',
      backgroundImage: 'url("/public/images/royalty-free/welcoming cabin.avif")',
    },
    dusky: {
      backgroundColor: '#2c1810',
      color: '#ffffff',
      accentColor: '#d2691e',
      secondaryColor: '#3c2415',
      borderColor: '#8b4513',
      backgroundImage: 'url("/public/images/royalty-free/blue red cabin.png")',
    },
  };

  return (
    <div style={styles[mode]}>
      {/* Rest of the component content */}
    </div>
  );
};

export default FiresideCabinTheme; 